#!/usr/local/bin/gnuplot
set terminal pdfcairo size 6in,4in linewidth 2.0 font "Arial,8" fontscale 1

set title font "Arial:Bold,10" noenhanced
set xlabel font "Arial:Bold,8" noenhanced
set ylabel font "Arial:Bold,8" noenhanced
set tics out nomirror font "Arial,6"
set key outside right center spacing 1.25 font "Arial,6"

set linetype 1 linewidth 2 pointtype 7
set linetype 2 linewidth 2 pointtype 5
set linetype 3 linewidth 2 pointtype 6
set linetype 4 linewidth 2 pointtype 4

set grid linetype -1 linewidth 0.5 linecolor "gray"

set format "%h"

set title "EOS Fluid Characterization \"SCN EOS\""
show title

$Expt << END
#                                                        Tb            Tc          Pc                                                          Visc                        Vc            VcVis
#  Component       LMW          MW          SG           (C)          (K)        (bar)         AF         VTran         Zc        ZcVis        (cp)        Pchor      (ft3/lbmol)     (ft3/lbmol)
#------------   ---------   ---------   ---------   ------------   ---------   ---------   ---------   ----------   ---------   ---------   ----------   ---------   -------------   -------------
     N2              NaN      28.014     0.28339     -195.90291     126.200     33.9800     0.03700     -0.16758     0.29178     0.29178          NaN       59.10        1.4433          1.4433
     CO2             NaN      44.010     0.76193      -88.26608     304.120     73.7400     0.22500      0.00191     0.27433     0.27433          NaN       80.00        1.5069          1.5069
     C1              NaN      16.043     0.14609     -161.59338     190.560     45.9900     0.01100     -0.14996     0.28620     0.28620          NaN       71.00        1.5794          1.5794
     C2              NaN      30.070     0.32976      -88.71667     305.320     48.7200     0.09900     -0.06280     0.27924     0.27924          NaN      111.00        2.3307          2.3307
     C3              NaN      44.097     0.50977      -42.21618     369.830     42.4800     0.15200     -0.06381     0.27630     0.27630          NaN      151.00        3.2037          3.2037
     I-C4            NaN      58.123     0.57043      -11.65811     407.850     36.4000     0.18600     -0.06197     0.28199     0.28199          NaN      188.80        4.2081          4.2081
     N-C4            NaN      58.123     0.59055       -0.51619     425.120     37.9600     0.20000     -0.05393     0.27385     0.27385          NaN      191.00        4.0847          4.0847
     I-C5            NaN      72.150     0.62952       28.01296     460.390     33.8100     0.22900     -0.05646     0.27231     0.27231          NaN      227.40        4.9385          4.9385
     N-C5            NaN      72.150     0.63585       36.18684     469.700     33.7000     0.25200     -0.02928     0.26837     0.26837          NaN      231.00        4.9817          4.9817
     C6           77.714      84.751     0.69921       64.83930     513.482     33.2738     0.24565     -0.02474     0.26937     0.26937          NaN      238.40        5.5365          5.5365
     C7           91.551      98.595     0.72940       94.25535     548.497     30.6745     0.28230     -0.00820     0.26470     0.26470          NaN      271.63        6.3039          6.3039
     C8          105.403     112.460     0.75398      121.35092     579.790     28.5096     0.31809      0.00569     0.26056     0.26382      0.25399      304.90        7.0573          7.1456
     C9          119.362     126.496     0.77457      146.51023     608.034     26.6688     0.35344      0.01630     0.25684     0.26193      0.31400      338.59        7.7990          7.9535
     C10         133.445     140.601     0.79195      169.99044     633.638     25.0637     0.38879      0.02551     0.25345     0.26089      0.38383      372.44        8.5337          8.7843
     C11         147.592     154.767     0.80682      191.98102     656.967     23.6316     0.42389      0.03433     0.25031     0.26023      0.46429      406.44        9.2681          9.6353
     C12         161.797     168.989     0.81967      212.63178     678.316     22.3551     0.45899      0.04227     0.24738     0.25991      0.55621      440.57        9.9972         10.5033
     C13         176.052     183.259     0.83088      232.06704     697.934     21.2094     0.49067      0.04946     0.24461     0.25980      0.66040      474.82       10.7204         11.3864
     C14         190.351     197.571     0.84075      250.39330     716.029     20.1758     0.52390      0.05598     0.24195     0.25987      0.77761      509.17       11.4364         12.2831
     C15         204.687     211.919     0.84950      267.70376     732.779     19.2390     0.55671      0.06189     0.23940     0.26006      0.90859      543.61       12.1441         13.1920
     C16         219.058     226.301     0.85730      284.08099     748.334     18.3869     0.58907      0.06723     0.23692     0.26035      1.05401      578.12       12.8421         14.1123
     C17         233.458     240.711     0.86430      299.59884     762.825     17.6091     0.62093      0.07203     0.23450     0.26073      1.21454      612.71       13.5295         15.0429
     C18         247.886     255.149     0.87063      314.32372     776.364     16.8968     0.65228      0.07634     0.23213     0.26119      1.39081      647.36       14.2053         15.9832
     C19         262.339     269.611     0.87636      328.31560     789.048     16.2427     0.68308      0.08019     0.22981     0.26171      1.58340      682.07       14.8688         16.9324
     C20         276.815     284.096     0.88158      341.62882     800.961     15.6403     0.71332      0.08359     0.22754     0.26230      1.79286      716.83       15.5195         17.8900
     C21         291.313     298.601     0.88635      354.31270     812.177     15.0840     0.74300      0.08660     0.22531     0.26294      2.01972      751.64       16.1571         18.8556
     C22         305.830     313.126     0.89074      366.41217     822.761     14.5690     0.77210      0.08923     0.22311     0.26363      2.26448      786.50       16.7813         19.8286
     C23         320.366     327.669     0.89477      377.96816     832.769     14.0910     0.80064      0.09152     0.22096     0.26437      2.52760      821.41       17.3920         20.8086
     C24         334.920     342.230     0.89850      389.01807     842.251     13.6463     0.82860      0.09349     0.21884     0.26514      2.80952      856.35       17.9892         21.7954
     C25         349.491     356.807     0.90196      399.59611     851.252     13.2316     0.85600      0.09518     0.21676     0.26596      3.11066      891.34       18.5731         22.7886
     C26         364.077     371.400     0.90517      409.73362     859.812     12.8441     0.88284      0.09660     0.21472     0.26681      3.43140      926.36       19.1439         23.7879
     C27         378.678     386.007     0.90817      419.45935     867.964     12.4812     0.90912      0.09777     0.21272     0.26769      3.77212      961.42       19.7017         24.7931
     C28         393.293     400.628     0.91096      428.79974     875.742     12.1406     0.93486      0.09873     0.21075     0.26859      4.13319      996.51       20.2469         25.8040
     C29         407.922     415.262     0.91358      437.77907     883.172     11.8204     0.96007      0.09948     0.20882     0.26952      4.51492     1031.63       20.7798         26.8202
     C30+        422.563     602.891     0.93649      528.47876     956.060      8.9445     1.23959      0.09809     0.18723     0.28233     11.32510     1481.94       26.6541         40.1923
END
set xlabel "Molecular Weight"
set ylabel "Specific Gravity"
set output "Figures/Table_005_SG_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:4 with points notitle
set ylabel "Boiling Temperature (C)"
set output "Figures/Table_005_TB_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:5 with points notitle
set ylabel "Critical Temperature (K)"
set output "Figures/Table_005_TC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:6 with points notitle
set ylabel "Critical Pressure (bar)"
set output "Figures/Table_005_PC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:7 with points notitle
set ylabel "Acentric Factor"
set output "Figures/Table_005_AF_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:8 with points notitle
set ylabel "Volume Translation"
set output "Figures/Table_005_VT_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:9 with points notitle
set ylabel "Critical Z-Factor"
set output "Figures/Table_005_ZC_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:10 with points notitle
set ylabel "Viscosity Z-Factor"
set output "Figures/Table_005_VISZ_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:11 with points notitle
set ylabel "Liquid Viscosity (cp)"
set output "Figures/Table_005_LVIS_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:12 with points notitle
set ylabel "Parachor"
set output "Figures/Table_005_PCHOR_vs_MW_1.pdf"
plot [*:*][*:*] $Expt using 3:13 with points notitle

set title "Lab1 Swelling Test"
show title

$Expt << END
#                             Mole Frac Inj                Sat Pres (barg)      Density (g/cm3)      Liq Vol Frac           C30+ K-Value
#  Stg     Mass Frac Inj           (%)           Feed       Expt    Calc         Expt     Calc       Expt    Calc         Expt        Calc
#------   ---------------   ----------------   -------   ------------------   ------------------   ----------------   ------------------------
     1        0.00000             0.000          NaN       232.42  232.42          NaN  0.69410     1.0000  1.0000            NaN  5.0548e-05
     2        0.06563            22.001          M23       272.47  286.09      0.65300  0.65825     1.0000  1.0000            NaN  8.9399e-04
     3        0.21770            52.775          M54       397.42  392.42      0.58000  0.59021     1.0000  1.0000            NaN  1.1294e-01
     4        0.26890            59.629          M61       425.37  431.32      0.56100  0.57255     1.0000  1.0000            NaN  7.5157e-01
     5        0.27500            60.368          NaN          NaN  436.93          NaN  0.57077        NaN  1.0000     1.0000e+00  1.0000e+00
     6        0.30676            63.990          M65       452.11  469.34      0.54700  0.56249     0.0000  0.0000            NaN  4.5739e-01
     7        0.45610            77.104          M78       586.05  615.17      0.49600  0.52878     0.0000  0.0000            NaN  1.4119e-01
     8        0.50000            80.063          NaN          NaN  646.56          NaN  0.51864        NaN  0.0000            NaN  1.1141e-01
     9        0.55000            83.074          NaN          NaN  672.26          NaN  0.50635        NaN  0.0000            NaN  8.5855e-02
    10        0.60000            85.762          NaN          NaN  685.42          NaN  0.49299        NaN  0.0000            NaN  6.6125e-02
    11        0.65000            88.177          NaN          NaN  684.84          NaN  0.47826        NaN  0.0000            NaN  5.0457e-02
    12        0.70000            90.357          NaN          NaN  670.23          NaN  0.46189        NaN  0.0000            NaN  3.7811e-02
    13        0.75000            92.336          NaN          NaN  642.09          NaN  0.44360        NaN  0.0000            NaN  2.7528e-02
    14        0.80000            94.139          NaN          NaN  601.30          NaN  0.42295        NaN  0.0000            NaN  1.9165e-02
    15        0.85000            95.791          NaN          NaN  548.28          NaN  0.39915        NaN  0.0000            NaN  1.2411e-02
    16        0.90000            97.308          NaN          NaN  481.72          NaN  0.37036        NaN  0.0000            NaN  7.0384e-03
    17        0.95000            98.706          NaN          NaN  394.07          NaN  0.33089        NaN  0.0000            NaN  2.8981e-03
END
set xlabel "Mass Fraction Injectant"
set ylabel "Saturation Pressure (barg)"
set output "Figures/Expt_002_SATP_vs_WFI_1.pdf"
plot [0:1][*<0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_002_DEN_vs_WFI_1.pdf"
plot [0:1][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"
set ylabel "Liquid Volume Fraction"
set output "Figures/Expt_002_LVF_vs_WFI_1.pdf"
plot [0:1][0:1] $Expt using 2:9 with points title "Expt", $Expt using 2:10 with lines title "Calc"

set title "Lab1 Viscosity Test"
show title

$Expt << END
#                            Pres                          Liq Vis (cp)
# Stg     Mass Frac Inj     (psig)     Mole Frac Inj       Expt     Calc
#-----   ---------------   --------   ---------------   ------------------
    1        0.06563        6000.0        0.22001        0.57800  0.44410
    2        0.21770        6200.0        0.52775        0.31700  0.20299
    3        0.26890        6450.0        0.59629        0.24500  0.16955
END
set xlabel "Mole Fraction Injectant"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_003_LVIS_vs_MFI_1.pdf"
plot [0:1][0:*] $Expt using 4:5 with points title "Expt", $Expt using 4:6 with lines title "Calc"

set title "P/V Test on Lab1 0% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liquid Volume (m3)       GOR (sm3/m3)         Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc           Expt       Calc        Expt    Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------------   ----------------   ----------------
     1     240.00     96.000          NaN  100.00             NaN  0.0001483        NaN   0.000        NaN  0.9981
     2     235.00     96.000          NaN  100.00             NaN  0.0001485        NaN   0.000        NaN  0.9993
     3     232.42     96.000       100.00  100.00             NaN  0.0001486        NaN   0.000        NaN  1.0000
     4     212.01     96.000        91.90   94.94             NaN  0.0001449        NaN  10.009        NaN  1.0268
     5     206.64     96.000        91.30   93.56             NaN  0.0001439        NaN  12.619        NaN  1.0351
     6     200.84     96.000        90.40   92.05             NaN  0.0001429        NaN  15.429        NaN  1.0448
     7     194.43     96.000        89.40   90.34             NaN  0.0001419        NaN  18.528        NaN  1.0565
     8     186.16     96.000        84.80   88.07             NaN  0.0001405        NaN  22.518        NaN  1.0732
     9     151.68     96.000        76.20   77.63             NaN  0.0001350        NaN  39.151        NaN  1.1704
    10     128.24     96.000        69.00   69.34             NaN  0.0001315        NaN  50.600        NaN  1.2762
    11     111.83     96.000        63.50   62.80             NaN  0.0001291        NaN  58.782        NaN  1.3829
    12      99.84     96.000        57.90   57.59             NaN  0.0001273        NaN  64.896        NaN  1.4873
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_004_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 23% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)         GOR (sm3/m3)           Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc        Expt      Calc        Expt    Calc
#------   --------   --------   --------------------   ----------------   --------------------   ----------------
     1     285.00     96.000          NaN   99.72          NaN  1.5723          NaN    0.6703        NaN  0.9885
     2     280.00     96.000          NaN   98.47          NaN  1.5595          NaN    3.7148        NaN  0.9929
     3     275.00     96.000          NaN   97.24          NaN  1.5471          NaN    6.7238        NaN  0.9975
     4     272.47     96.000       100.00   96.62          NaN  1.5410          NaN    8.2338        NaN  1.0000
     5     241.66     96.000        83.50   89.13          NaN  1.4733          NaN   26.0786        NaN  1.0363
     6     235.39     96.000        83.00   87.60          NaN  1.4607          NaN   29.6145        NaN  1.0454
     7     214.43     96.000        79.20   82.37          NaN  1.4210          NaN   41.2864        NaN  1.0815
     8     155.82     96.000        65.40   65.85          NaN  1.3219          NaN   73.6112        NaN  1.2587
     9     101.63     96.000        49.60   46.37          NaN  1.2359          NaN  105.1219        NaN  1.6709
    10      75.84     96.000        39.10   35.36          NaN  1.1928          NaN  121.8338        NaN  2.1147
    11      60.67     96.000        31.10   28.41          NaN  1.1653          NaN  132.7448        NaN  2.5716
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_005_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 54% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)        GOR (sm3/m3)          Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc        Expt     Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------   ------------------   ----------------
     1     400.00     96.000          NaN  100.00          NaN  2.2890         NaN    0.000        NaN  0.9991
     2     397.42     96.000       100.00  100.00          NaN  2.2910         NaN    0.000        NaN  1.0000
     3     395.21     96.000        88.10  100.00          NaN  2.2927         NaN    0.000        NaN  1.0008
     4     390.93     96.000        85.70   99.11          NaN  2.2763         NaN    2.492        NaN  1.0025
     5     381.35     96.000        79.40   94.42          NaN  2.1800         NaN   16.458        NaN  1.0079
     6     367.90     96.000        76.90   89.61          NaN  2.0861         NaN   32.161        NaN  1.0161
     7     343.36     96.000        73.60   83.21          NaN  1.9710         NaN   54.981        NaN  1.0340
     8     255.66     96.000        62.20   66.32          NaN  1.7381         NaN  116.622        NaN  1.1439
     9     197.88     96.000        51.50   54.63          NaN  1.6277         NaN  153.527        NaN  1.3004
    10     147.34     96.000        40.20   42.31          NaN  1.5332         NaN  188.204        NaN  1.5819
    11     118.73     96.000        35.20   34.31          NaN  1.4761         NaN  210.362        NaN  1.8780
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_006_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 61% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)       GOR (sm3/m3)         Rel Vol 1
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc       Expt    Calc       Expt    Calc
#------   --------   --------   --------------------   ----------------   ----------------   ----------------
     1     440.00     96.000          NaN  100.00          NaN  2.4819        NaN    0.00        NaN  0.9944
     2     435.00     96.000          NaN  100.00          NaN  2.4862        NaN    0.00        NaN  0.9961
     3     430.00     96.000          NaN   89.38          NaN  2.2263        NaN   29.87        NaN  0.9979
     4     425.37     96.000       100.00   82.45          NaN  2.0579        NaN   55.03        NaN  1.0000
     5     421.96     96.000        88.60   81.30          NaN  2.0325        NaN   60.33        NaN  1.0016
     6     415.75     96.000        83.10   80.25          NaN  2.0122        NaN   65.84        NaN  1.0046
     7     410.10     96.000        79.30   79.50          NaN  1.9992        NaN   69.84        NaN  1.0075
     8     398.86     96.000        75.20   78.06          NaN  1.9748        NaN   77.31        NaN  1.0136
     9     388.45     96.000        69.70   76.71          NaN  1.9526        NaN   84.07        NaN  1.0198
    10     378.18     96.000        69.60   75.37          NaN  1.9310        NaN   90.64        NaN  1.0265
    11     368.52     96.000        66.00   74.11          NaN  1.9114        NaN   96.72        NaN  1.0333
    12     350.18     96.000        65.90   71.72          NaN  1.8757        NaN  108.03        NaN  1.0478
    13     333.36     96.000        62.80   69.52          NaN  1.8448        NaN  118.20        NaN  1.0632
    14     270.76     96.000        56.50   60.82          NaN  1.7404        NaN  155.07        NaN  1.1465
    15     218.22     96.000        51.20   52.17          NaN  1.6581        NaN  186.61        NaN  1.2733
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_007_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 65% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)      Liq Vol (m3)       GOR (sm3/m3)         Rel Vol 1               N2 x                    CO2 x                 C1 x                  C2 x                   C3 x                   I-C4 x                  N-C4 x                  I-C5 x                  N-C5 x                 C6-C7 x                C8-C9 x               C10-C13 x              C14-C19 x              C20-C29 x               C30+ x                 C6+ x          Gas N2 Mole Fraction            CO2 y                 C1 y                  C2 y                   C3 y                   I-C4 y                  N-C4 y                  I-C5 y                  N-C5 y                 C6-C7 y                C8-C9 y               C10-C13 y              C14-C19 y               C20-C29 y          Gas C30+ Mole Fraction           C6+ y            N2 K-Value         CO2 K-Value        C1 K-Value         C2 K-Value         C3 K-Value         I-C4 K-Value         N-C4 K-Value         I-C5 K-Value         N-C5 K-Value         C6-C7 K-Value        C8-C9 K-Value       C10-C13 K-Value      C14-C19 K-Value       C20-C29 K-Value          C30+ K-Value            C6+ K-Value
#  Stg     (barg)       (C)         Expt    Calc         Expt    Calc       Expt    Calc       Expt    Calc         Expt       Calc         Expt      Calc         Expt     Calc        Expt      Calc         Expt      Calc          Expt       Calc         Expt      Calc          Expt       Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt     Calc         Expt       Calc         Expt      Calc         Expt     Calc        Expt      Calc         Expt      Calc          Expt       Calc         Expt      Calc          Expt       Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc         Expt      Calc          Expt       Calc          Expt        Calc          Expt     Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt     Calc        Expt      Calc          Expt       Calc         Expt     Calc
#------   --------   --------   --------------------   ----------------   ----------------   ----------------   ----------------------   --------------------   ------------------   --------------------   --------------------   ----------------------   --------------------   ----------------------   --------------------   --------------------   --------------------   --------------------   --------------------   --------------------   --------------------   ------------------   ----------------------   --------------------   ------------------   --------------------   --------------------   ----------------------   --------------------   ----------------------   --------------------   --------------------   --------------------   --------------------   --------------------   ----------------------   ------------------------   ------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   ------------------   --------------------   ----------------------   ------------------
     1     480.00     96.000          NaN   0.000          NaN  0.0000        NaN                NaN  0.9896           NaN  0.0025899          NaN  0.013863         NaN  0.56350          NaN  0.087016          NaN  0.078486           NaN  0.0033160          NaN  0.038599           NaN  0.0042213          NaN  0.019056          NaN  0.043677          NaN  0.025165          NaN  0.030726          NaN  0.027166          NaN  0.023530          NaN  0.039092         NaN  0.18935           NaN  0.0027690          NaN  0.014161         NaN  0.59970          NaN  0.088612          NaN  0.078816           NaN  0.0033044          NaN  0.038200           NaN  0.0041402          NaN  0.018618          NaN  0.041845          NaN  0.023457          NaN  0.027589          NaN  0.022939           NaN  0.0180409            NaN  1.7807e-02         NaN  0.15168        NaN  1.0618        NaN  1.0192        NaN  1.0574        NaN  1.0164        NaN  1.0038         NaN  0.99686         NaN  0.99075         NaN  0.98283         NaN  0.97942         NaN  0.96251         NaN  0.93934         NaN  0.90878         NaN  0.86096          NaN  0.791525           NaN  0.5133791         NaN  0.82217
     2     475.00     96.000          NaN   0.000          NaN  0.0000        NaN                NaN  0.9912           NaN  0.0025837          NaN  0.013856         NaN  0.56256          NaN  0.087002          NaN  0.078529           NaN  0.0033192          NaN  0.038647           NaN  0.0042284          NaN  0.019092          NaN  0.043794          NaN  0.025261          NaN  0.030887          NaN  0.027366          NaN  0.023766          NaN  0.039109         NaN  0.19018           NaN  0.0027690          NaN  0.014161         NaN  0.59970          NaN  0.088612          NaN  0.078816           NaN  0.0033044          NaN  0.038200           NaN  0.0041402          NaN  0.018618          NaN  0.041845          NaN  0.023457          NaN  0.027589          NaN  0.022939           NaN  0.0180409            NaN  1.7807e-02         NaN  0.15168        NaN  1.0678        NaN  1.0208        NaN  1.0624        NaN  1.0175        NaN  1.0035         NaN  0.99579         NaN  0.98906         NaN  0.98030         NaN  0.97654         NaN  0.95797         NaN  0.93255         NaN  0.89916         NaN  0.84724          NaN  0.772492           NaN  0.4855691         NaN  0.80879
     3     470.00     96.000          NaN   0.000          NaN  0.0000        NaN                NaN  0.9929           NaN  0.0025781          NaN  0.013851         NaN  0.56179          NaN  0.087001          NaN  0.078581           NaN  0.0033227          NaN  0.038698           NaN  0.0042358          NaN  0.019128          NaN  0.043910          NaN  0.025355          NaN  0.031043          NaN  0.027555          NaN  0.023984          NaN  0.038964         NaN  0.19081           NaN  0.0027690          NaN  0.014161         NaN  0.59970          NaN  0.088612          NaN  0.078816           NaN  0.0033044          NaN  0.038200           NaN  0.0041402          NaN  0.018618          NaN  0.041845          NaN  0.023457          NaN  0.027589          NaN  0.022939           NaN  0.0180409            NaN  1.7807e-02         NaN  0.15168        NaN  1.0736        NaN  1.0222        NaN  1.0670        NaN  1.0184        NaN  1.0030         NaN  0.99453         NaN  0.98720         NaN  0.97758         NaN  0.97349         NaN  0.95328         NaN  0.92562         NaN  0.88947         NaN  0.83358          NaN  0.753827           NaN  0.4605372         NaN  0.79625
     4     465.00     96.000          NaN   4.747          NaN  0.1256        NaN  5015.2        NaN  0.9948           NaN  0.0025732          NaN  0.013847         NaN  0.56120          NaN  0.087012          NaN  0.078642           NaN  0.0033265          NaN  0.038753           NaN  0.0042434          NaN  0.019165          NaN  0.044026          NaN  0.025447          NaN  0.031193          NaN  0.027733          NaN  0.024181          NaN  0.038654         NaN  0.19123           NaN  0.0027774          NaN  0.014174         NaN  0.60135          NaN  0.088681          NaN  0.078824           NaN  0.0033035          NaN  0.038176           NaN  0.0041358          NaN  0.018594          NaN  0.041751          NaN  0.023372          NaN  0.027435          NaN  0.022734           NaN  0.0177782            NaN  1.6915e-02         NaN  0.14999        NaN  1.0793        NaN  1.0236        NaN  1.0715        NaN  1.0192        NaN  1.0023         NaN  0.99306         NaN  0.98513         NaN  0.97463         NaN  0.97020         NaN  0.94833         NaN  0.91844         NaN  0.87953         NaN  0.81976          NaN  0.735210           NaN  0.4376038         NaN  0.78431
     5     460.00     96.000          NaN   9.939          NaN  0.2634        NaN  2278.5        NaN  0.9968           NaN  0.0025691          NaN  0.013846         NaN  0.56080          NaN  0.087036          NaN  0.078712           NaN  0.0033308          NaN  0.038810           NaN  0.0042514          NaN  0.019204          NaN  0.044142          NaN  0.025537          NaN  0.031336          NaN  0.027898          NaN  0.024356          NaN  0.038176         NaN  0.19144           NaN  0.0027879          NaN  0.014191         NaN  0.60337          NaN  0.088761          NaN  0.078826           NaN  0.0033019          NaN  0.038142           NaN  0.0041298          NaN  0.018562          NaN  0.041628          NaN  0.023261          NaN  0.027236          NaN  0.022472           NaN  0.0174461            NaN  1.5888e-02         NaN  0.14793        NaN  1.0852        NaN  1.0249        NaN  1.0759        NaN  1.0198        NaN  1.0015         NaN  0.99134         NaN  0.98279         NaN  0.97139         NaN  0.96660         NaN  0.94305         NaN  0.91086         NaN  0.86917         NaN  0.80553          NaN  0.716310           NaN  0.4161891         NaN  0.77272
     6     455.00     96.000          NaN  15.008          NaN  0.3986        NaN  1432.8        NaN  0.9988           NaN  0.0025656          NaN  0.013846         NaN  0.56058          NaN  0.087074          NaN  0.078793           NaN  0.0033354          NaN  0.038872           NaN  0.0042597          NaN  0.019243          NaN  0.044258          NaN  0.025625          NaN  0.031472          NaN  0.028047          NaN  0.024503          NaN  0.037527         NaN  0.19143           NaN  0.0027995          NaN  0.014208         NaN  0.60557          NaN  0.088843          NaN  0.078820           NaN  0.0032998          NaN  0.038099           NaN  0.0041223          NaN  0.018524          NaN  0.041483          NaN  0.023132          NaN  0.027007          NaN  0.022173           NaN  0.0170719            NaN  1.4850e-02         NaN  0.14572        NaN  1.0912        NaN  1.0262        NaN  1.0803        NaN  1.0203        NaN  1.0003         NaN  0.98932         NaN  0.98012         NaN  0.96776         NaN  0.96259         NaN  0.93729         NaN  0.90271         NaN  0.85815         NaN  0.79057          NaN  0.696731           NaN  0.3957256         NaN  0.76120
     7     452.11     96.000        0.000  17.944          NaN  0.4771        NaN  1161.3        NaN  1.0000           NaN  0.0025640          NaN  0.013847         NaN  0.56055          NaN  0.087102          NaN  0.078844           NaN  0.0033382          NaN  0.038909           NaN  0.0042646          NaN  0.019267          NaN  0.044325          NaN  0.025674          NaN  0.031546          NaN  0.028126          NaN  0.024574          NaN  0.037073         NaN  0.19132           NaN  0.0028070          NaN  0.014219         NaN  0.60695          NaN  0.088892          NaN  0.078811           NaN  0.0032981          NaN  0.038069           NaN  0.0041172          NaN  0.018497          NaN  0.041386          NaN  0.023046          NaN  0.026857          NaN  0.021979           NaN  0.0168311            NaN  1.4239e-02         NaN  0.14434        NaN  1.0948        NaN  1.0269        NaN  1.0828        NaN  1.0205        NaN  0.9996         NaN  0.98799         NaN  0.97840         NaN  0.96544         NaN  0.96005         NaN  0.93368         NaN  0.89764         NaN  0.85136         NaN  0.78144          NaN  0.684911           NaN  0.3840889         NaN  0.75444
     8     438.02     96.000       40.300  32.969          NaN  0.8820        NaN   527.6        NaN  1.0061           NaN  0.0025589          NaN  0.013861         NaN  0.56119          NaN  0.087307          NaN  0.079147           NaN  0.0033542          NaN  0.039110           NaN  0.0042904          NaN  0.019389          NaN  0.044652          NaN  0.025903          NaN  0.031867          NaN  0.028424          NaN  0.024759          NaN  0.034185         NaN  0.18979           NaN  0.0028555          NaN  0.014284         NaN  0.61554          NaN  0.089149          NaN  0.078680           NaN  0.0032839          NaN  0.037825           NaN  0.0040784          NaN  0.018300          NaN  0.040690          NaN  0.022451          NaN  0.025830          NaN  0.020684           NaN  0.0152776            NaN  1.1071e-02         NaN  0.13600        NaN  1.1159        NaN  1.0305        NaN  1.0968        NaN  1.0211        NaN  0.9941         NaN  0.97904         NaN  0.96715         NaN  0.95059         NaN  0.94388         NaN  0.91126         NaN  0.86674         NaN  0.81057         NaN  0.72768          NaN  0.617046           NaN  0.3238641         NaN  0.71660
     9     431.89     96.000       40.000  39.693          NaN  1.0650        NaN   398.7        NaN  1.0090           NaN  0.0025567          NaN  0.013870         NaN  0.56159          NaN  0.087416          NaN  0.079302           NaN  0.0033623          NaN  0.039210           NaN  0.0043031          NaN  0.019448          NaN  0.044807          NaN  0.026007          NaN  0.032004          NaN  0.028532          NaN  0.024783          NaN  0.032806         NaN  0.18894           NaN  0.0028852          NaN  0.014320         NaN  0.62054          NaN  0.089266          NaN  0.078551           NaN  0.0032728          NaN  0.037647           NaN  0.0040511          NaN  0.018163          NaN  0.040225          NaN  0.022062          NaN  0.025176          NaN  0.019881           NaN  0.0143546            NaN  9.6058e-03         NaN  0.13130        NaN  1.1285        NaN  1.0325        NaN  1.1050        NaN  1.0212        NaN  0.9905         NaN  0.97338         NaN  0.96014         NaN  0.94144         NaN  0.93395         NaN  0.89773         NaN  0.84833         NaN  0.78665         NaN  0.69681          NaN  0.579222           NaN  0.2928079         NaN  0.69496
    10     426.23     96.000       41.000  45.432          NaN  1.2223        NaN   318.6        NaN  1.0118           NaN  0.0025529          NaN  0.013875         NaN  0.56169          NaN  0.087510          NaN  0.079452           NaN  0.0033703          NaN  0.039312           NaN  0.0043163          NaN  0.019510          NaN  0.044973          NaN  0.026120          NaN  0.032155          NaN  0.028656          NaN  0.024820          NaN  0.031689         NaN  0.18841           NaN  0.0029174          NaN  0.014357         NaN  0.62580          NaN  0.089368          NaN  0.078380           NaN  0.0032591          NaN  0.037436           NaN  0.0040194          NaN  0.018005          NaN  0.039697          NaN  0.021628          NaN  0.024455          NaN  0.019015           NaN  0.0133867            NaN  8.2769e-03         NaN  0.12646        NaN  1.1428        NaN  1.0348        NaN  1.1141        NaN  1.0212        NaN  0.9865         NaN  0.96701         NaN  0.95229         NaN  0.93121         NaN  0.92287         NaN  0.88269         NaN  0.82802         NaN  0.76051         NaN  0.66357          NaN  0.539349           NaN  0.2611954         NaN  0.67118
    11     420.10     96.000       42.600  50.622          NaN  1.3662        NaN   261.6        NaN  1.0150           NaN  0.0025458          NaN  0.013877         NaN  0.56126          NaN  0.087595          NaN  0.079620           NaN  0.0033798          NaN  0.039435           NaN  0.0043326          NaN  0.019587          NaN  0.045189          NaN  0.026273          NaN  0.032369          NaN  0.028846          NaN  0.024919          NaN  0.030771         NaN  0.18837           NaN  0.0029560          NaN  0.014399         NaN  0.63189          NaN  0.089463          NaN  0.078143           NaN  0.0032413          NaN  0.037165           NaN  0.0039791          NaN  0.017805          NaN  0.039044          NaN  0.021098          NaN  0.023587          NaN  0.017993           NaN  0.0122812            NaN  6.9513e-03         NaN  0.12095        NaN  1.1612        NaN  1.0376        NaN  1.1258        NaN  1.0213        NaN  0.9814         NaN  0.95901         NaN  0.94244         NaN  0.91841         NaN  0.90903         NaN  0.86402         NaN  0.80302         NaN  0.72868         NaN  0.62377          NaN  0.492844           NaN  0.2259066         NaN  0.64212
    12     414.24     96.000       43.500  54.411          NaN  1.4731        NaN   226.8        NaN  1.0182           NaN  0.0025357          NaN  0.013873         NaN  0.56027          NaN  0.087657          NaN  0.079787           NaN  0.0033897          NaN  0.039567           NaN  0.0043505          NaN  0.019673          NaN  0.045436          NaN  0.026454          NaN  0.032630          NaN  0.029094          NaN  0.025087          NaN  0.030193         NaN  0.18889           NaN  0.0029944          NaN  0.014439         NaN  0.63777          NaN  0.089534          NaN  0.077880           NaN  0.0032221          NaN  0.036880           NaN  0.0039372          NaN  0.017599          NaN  0.038378          NaN  0.020563          NaN  0.022723          NaN  0.016997           NaN  0.0112382            NaN  5.8492e-03         NaN  0.11575        NaN  1.1809        NaN  1.0408        NaN  1.1383        NaN  1.0214        NaN  0.9761         NaN  0.95057         NaN  0.93209         NaN  0.90501         NaN  0.89456         NaN  0.84465         NaN  0.77733         NaN  0.69639         NaN  0.58421          NaN  0.447974           NaN  0.1937287         NaN  0.61277
    13     402.86     96.000       46.100  59.038          NaN  1.6088        NaN   190.4        NaN  1.0248           NaN  0.0025082          NaN  0.013855         NaN  0.55700          NaN  0.087731          NaN  0.080129           NaN  0.0034110          NaN  0.039861           NaN  0.0043912          NaN  0.019870          NaN  0.046021          NaN  0.026892          NaN  0.033280          NaN  0.029745          NaN  0.025596          NaN  0.029709         NaN  0.19124           NaN  0.0030676          NaN  0.014511         NaN  0.64857          NaN  0.089620          NaN  0.077314           NaN  0.0031824          NaN  0.036299           NaN  0.0038530          NaN  0.017184          NaN  0.037065          NaN  0.019525          NaN  0.021076          NaN  0.015151           NaN  0.0093943            NaN  4.1854e-03         NaN  0.10640        NaN  1.2230        NaN  1.0473        NaN  1.1644        NaN  1.0215        NaN  0.9649         NaN  0.93297         NaN  0.91065         NaN  0.87743         NaN  0.86484         NaN  0.80538         NaN  0.72607         NaN  0.63330         NaN  0.50937          NaN  0.367025           NaN  0.1408813         NaN  0.55635
    14     381.69     96.000       48.500  62.243          NaN  1.7193        NaN   168.0        NaN  1.0388           NaN  0.0024383          NaN  0.013794         NaN  0.54784          NaN  0.087785          NaN  0.080851           NaN  0.0034583          NaN  0.040524           NaN  0.0044850          NaN  0.020326          NaN  0.047404          NaN  0.027943          NaN  0.034862          NaN  0.031359          NaN  0.026941          NaN  0.029989         NaN  0.19850           NaN  0.0031901          NaN  0.014628         NaN  0.66572          NaN  0.089665          NaN  0.076227           NaN  0.0031085          NaN  0.035241           NaN  0.0037013          NaN  0.016443          NaN  0.034767          NaN  0.017745          NaN  0.018331          NaN  0.012221           NaN  0.0067103            NaN  2.2997e-03         NaN  0.09208        NaN  1.3083        NaN  1.0605        NaN  1.2152        NaN  1.0214        NaN  0.9428         NaN  0.89884         NaN  0.86965         NaN  0.82527         NaN  0.80899         NaN  0.73342         NaN  0.63506         NaN  0.52582         NaN  0.38973          NaN  0.249071           NaN  0.0766849         NaN  0.46386
    15     362.39     96.000       49.400  62.525          NaN  1.7518        NaN   165.4        NaN  1.0537           NaN  0.0023604          NaN  0.013716         NaN  0.53737          NaN  0.087792          NaN  0.081614           NaN  0.0035097          NaN  0.041248           NaN  0.0045883          NaN  0.020828          NaN  0.048937          NaN  0.029110          NaN  0.036609          NaN  0.033120          NaN  0.028395          NaN  0.030797         NaN  0.20697           NaN  0.0032866          NaN  0.014724         NaN  0.67865          NaN  0.089650          NaN  0.075272           NaN  0.0030444          NaN  0.034339           NaN  0.0035727          NaN  0.015817          NaN  0.032861          NaN  0.016296          NaN  0.016164          NaN  0.010044           NaN  0.0049253            NaN  1.3525e-03         NaN  0.08164        NaN  1.3924        NaN  1.0735        NaN  1.2629        NaN  1.0212        NaN  0.9223         NaN  0.86742         NaN  0.83250         NaN  0.77865         NaN  0.75940         NaN  0.67151         NaN  0.55981         NaN  0.44151         NaN  0.30326          NaN  0.173458           NaN  0.0439167         NaN  0.39447
    16     314.68     96.000       48.500  59.597          NaN  1.7470        NaN   178.4        NaN  1.1024           NaN  0.0021267          NaN  0.013446         NaN  0.50541          NaN  0.087715          NaN  0.083980           NaN  0.0036727          NaN  0.043539           NaN  0.0049177          NaN  0.022431          NaN  0.053800          NaN  0.032779          NaN  0.041968          NaN  0.038257          NaN  0.032379          NaN  0.033581         NaN  0.23276           NaN  0.0034801          NaN  0.014953         NaN  0.70408          NaN  0.089606          NaN  0.073101           NaN  0.0028967          NaN  0.032290           NaN  0.0032796          NaN  0.014397          NaN  0.028611          NaN  0.013137          NaN  0.011673          NaN  0.005984           NaN  0.0021692            NaN  3.4569e-04         NaN  0.06192        NaN  1.6364        NaN  1.1121        NaN  1.3931        NaN  1.0216        NaN  0.8705         NaN  0.78873         NaN  0.74164         NaN  0.66690         NaN  0.64183         NaN  0.53179         NaN  0.40078         NaN  0.27813         NaN  0.15641          NaN  0.066993           NaN  0.0102943         NaN  0.26602
    17     259.10     96.000       45.900  53.448          NaN  1.6967        NaN   204.1        NaN  1.1939           NaN  0.0017930          NaN  0.012947         NaN  0.45750          NaN  0.087342          NaN  0.087719           NaN  0.0039420          NaN  0.047300           NaN  0.0054664          NaN  0.025095          NaN  0.061798          NaN  0.038667          NaN  0.050092          NaN  0.045326          NaN  0.037400          NaN  0.037609         NaN  0.27089           NaN  0.0036442          NaN  0.015250         NaN  0.72720          NaN  0.089750          NaN  0.070834           NaN  0.0027327          NaN  0.030040           NaN  0.0029511          NaN  0.012809          NaN  0.023954          NaN  0.009818          NaN  0.007413          NaN  0.002867           NaN  0.0006829            NaN  5.1974e-05         NaN  0.04479        NaN  2.0325        NaN  1.1779        NaN  1.5895        NaN  1.0276        NaN  0.8075         NaN  0.69322         NaN  0.63509         NaN  0.53986         NaN  0.51043         NaN  0.38761         NaN  0.25392         NaN  0.14799         NaN  0.06325          NaN  0.018258           NaN  0.0013819         NaN  0.16533
    18     222.29     96.000       42.500  48.131          NaN  1.6535        NaN   224.0        NaN  1.2920     0.0012831  0.0015415     0.014805  0.012451     0.41119  0.41833     0.084685  0.086701     0.089818  0.090842     0.0042441  0.0041815     0.051522  0.050637     0.0061194  0.0059624     0.028919  0.027501     0.073236  0.068938     0.043626  0.043760     0.062872  0.056681     0.051324  0.050599     0.038888  0.041040     0.037472  0.040836     0.29830  0.30185     0.0039012  0.0037177     0.020706  0.015482     0.72523  0.73986     0.090929  0.090089     0.070522  0.069523     0.0035011  0.0026266     0.029409  0.028589     0.0030010  0.0027321     0.011003  0.011753     0.020507  0.020907     0.009303  0.007767     0.008403  0.005108     0.002901  0.001565     0.0006002  0.0002672     8.3800e-05  1.0965e-05     0.04220  0.03563     3.0404  2.4117     1.3986  1.2434     1.7637  1.7686     1.0737  1.0391     0.7852  0.7653     0.82493  0.62815     0.57081  0.56458     0.49040  0.45822     0.38049  0.42735     0.28001  0.30328     0.21324  0.17749     0.13365  0.09012     0.05652  0.03092     0.015434  0.006511     0.0022355  0.0002685     0.14150  0.11802
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_008_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "P/V Test on Lab1 78% Solvent/Oil Mixture"
show title

$Expt << END
#           Pres       Temp      Liq Vol Frac 2 (%)       Liquid Volume (m3)            GOR (sm3/m3)             Rel Vol 1
#  Stg     (barg)       (C)        Expt      Calc          Expt        Calc           Expt        Calc         Expt    Calc
#------   --------   --------   --------------------   ------------------------   ------------------------   ----------------
     1     630.00     96.000          NaN   0.00000            NaN  0.0000e+00            NaN                    NaN  0.9858
     2     625.00     96.000          NaN   0.00000            NaN  0.0000e+00            NaN                    NaN  0.9873
     3     620.00     96.000          NaN   0.00000            NaN  0.0000e+00            NaN                    NaN  0.9888
     4     615.00     96.000          NaN   0.01402            NaN  4.6075e-04            NaN  2.0577e+06        NaN  0.9904
     5     610.00     96.000          NaN   0.42989            NaN  1.4153e-02            NaN  6.6805e+04        NaN  0.9920
     6     605.00     96.000          NaN   0.84232            NaN  2.7777e-02            NaN  3.3947e+04        NaN  0.9936
     7     600.00     96.000          NaN   1.25153            NaN  4.1341e-02            NaN  2.2749e+04        NaN  0.9952
     8     595.00     96.000          NaN   1.65772            NaN  5.4851e-02            NaN  1.7100e+04        NaN  0.9969
     9     590.00     96.000          NaN   2.06113            NaN  6.8315e-02            NaN  1.3693e+04        NaN  0.9986
    10     586.05     96.000      0.00000   2.37800            NaN  7.8926e-02            NaN  1.1828e+04        NaN  1.0000
    11     442.09     96.000     18.50000  14.93218            NaN  5.2833e-01            NaN  1.6132e+03        NaN  1.0660
    12     430.92     96.000     19.80000  16.40907            NaN  5.8448e-01            NaN  1.4396e+03        NaN  1.0732
    13     419.41     96.000     20.80000  18.14304            NaN  6.5099e-01            NaN  1.2721e+03        NaN  1.0811
    14     398.03     96.000     25.40000  21.94777            NaN  7.9942e-01            NaN  9.9797e+02        NaN  1.0974
    15     377.83     96.000     26.40000  25.83457            NaN  9.5635e-01            NaN  8.0023e+02        NaN  1.1153
    16     350.39     96.000     28.90000  30.24532            NaN  1.1488e+00            NaN  6.3252e+02        NaN  1.1444
    17     284.41     96.000     31.80000  34.14492            NaN  1.4137e+00            NaN  4.8397e+02        NaN  1.2475
    18     239.94     96.000     30.20000  32.80147            NaN  1.4849e+00            NaN  4.5973e+02        NaN  1.3639
    19     210.36     96.000     28.90000  30.59454            NaN  1.5037e+00            NaN  4.5791e+02        NaN  1.4808
    20     188.43     96.000     31.60000  28.33221            NaN  1.5052e+00            NaN  4.6231e+02        NaN  1.6007
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume Fraction, After Removal (%)"
set output "Figures/Expt_009_LVF2_vs_PRES_1.pdf"
plot [*<0:*][0:100] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"

set title "Lab2 Constant Composition Expansion"
show title

$Expt << END
#           Pres          Rel Vol         Liq Den (kg/m3)      Liq Vis (cp)
#  Stg     (barg)      Expt    Calc        Expt    Calc        Expt    Calc
#------   --------   ----------------   ------------------   ----------------
     1     379.21     0.9761  0.9693      706.80  710.00      0.4760  0.6159
     2     344.74     0.9819  0.9758      702.60  705.29      0.4560  0.5792
     3     310.26     0.9879  0.9829      698.40  700.20      0.4340  0.5423
     4     275.79     0.9943  0.9907      693.90  694.66      0.4130  0.5055
     5     268.90     0.9956  0.9924      692.90  693.49      0.4090  0.4981
     6     262.00     0.9970  0.9941      692.00  692.30      0.4040  0.4907
     7     255.11     0.9983  0.9958      691.10  691.09      0.4000  0.4833
     8     246.83     1.0000  1.0000      689.90  691.13      0.3950  0.4822
     9     236.35     1.0115  1.0119         NaN  695.49         NaN  0.5030
    10     215.94     1.0389  1.0399         NaN  703.98         NaN  0.5467
    11     194.09     1.0777  1.0794         NaN  713.16         NaN  0.5986
    12     170.37     1.1359  1.1382         NaN  723.28         NaN  0.6622
    13     148.10     1.2139  1.2162         NaN  733.00         NaN  0.7302
    14     126.93     1.3210  1.3226         NaN  742.51         NaN  0.8042
    15     108.32     1.4583  1.4578         NaN  751.16         NaN  0.8783
    16      90.32     1.6556  1.6504         NaN  759.87         NaN  0.9602
    17      81.91     1.7821  1.7731         NaN  764.09         NaN  1.0027
END
set xlabel "Pressure (barg)"
set ylabel "Relative Volume"
set output "Figures/Expt_013_RV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"

set title "Lab2 Differential Liberation"
show title

$Expt << END
#           Temp       Pres                    Liq Vol (m3)        Removed (sm3)       Liq Den (kg/m3)      Liq Vis (cp)       Gas Z-Factor      Gas Sp Gravity        Gas Vis (cp)
#  Stg       (C)      (barg)      Stg Wgt      Expt    Calc        Expt     Calc        Expt    Calc        Expt    Calc       Expt    Calc       Expt    Calc        Expt      Calc
#------   --------   --------   ----------   ----------------   ------------------   ------------------   ----------------   ----------------   ----------------   --------------------
     1     100.00     379.21       1.00       1.4660  1.4559         NaN    0.000      706.80  710.00      0.4760  0.6159        NaN  1.0396        NaN  0.9490          NaN  0.040468
     2     100.00     344.74       1.00       1.4750  1.4656         NaN    0.000      702.60  705.29      0.4560  0.5792        NaN  0.9907        NaN  0.8859          NaN  0.035213
     3     100.00     310.26       1.00       1.4840  1.4763         NaN    0.000      698.40  700.20      0.4340  0.5423        NaN  0.9516        NaN  0.8382          NaN  0.030955
     4     100.00     275.79       1.00       1.4930  1.4881         NaN    0.000      693.90  694.66      0.4130  0.5055        NaN  0.9205        NaN  0.8007          NaN  0.027286
     5     100.00     268.90       1.00       1.4950  1.4906         NaN    0.000      692.90  693.49      0.4090  0.4981        NaN  0.9153        NaN  0.7942          NaN  0.026606
     6     100.00     262.00       1.00       1.4970  1.4931         NaN    0.000      692.00  692.30      0.4040  0.4907        NaN  0.9103        NaN  0.7880          NaN  0.025942
     7     100.00     255.11       1.00       1.4990  1.4957         NaN    0.000      691.10  691.09      0.4000  0.4833        NaN  0.9056        NaN  0.7821          NaN  0.025294
     8     100.00     246.83       1.00       1.5020  1.4931       0.000    1.874      689.90  691.13      0.3950  0.4822        NaN  0.9004        NaN  0.7753          NaN  0.024536
     9     100.00     220.63       1.00       1.4550  1.4458      18.340   20.129      700.10  702.04      0.4250  0.5363     0.8780  0.8869     0.7920  0.7565     0.022900  0.022284
    10     100.00     193.05       1.00       1.4110  1.3995      35.950   38.026      710.20  713.70      0.4730  0.6020     0.8670  0.8778     0.7650  0.7405     0.020700  0.020160
    11     100.00     165.47       1.00       1.3700  1.3560      52.490   54.765      720.20  725.59      0.5380  0.6782     0.8640  0.8740     0.7490  0.7286     0.019000  0.018311
    12     100.00     137.90       1.00       1.3320  1.3149      68.140   70.498      730.20  737.72      0.6170  0.7669     0.8690  0.8757     0.7430  0.7213     0.017500  0.016751
    13     100.00     110.32       1.00       1.2950  1.2757      83.430   85.373      740.00  750.14      0.7080  0.8704     0.8790  0.8832     0.7510  0.7199     0.016200  0.015477
    14     100.00      82.74       1.00       1.2590  1.2379      98.370   99.527      750.00  762.90      0.8310  0.9914     0.8940  0.8963     0.7720  0.7275     0.015100  0.014462
    15     100.00      55.16       1.00       1.2230  1.2005     112.950  113.186      760.70  776.16      1.0360  1.1339     0.9130  0.9150     0.7930  0.7533     0.014100  0.013646
    16     100.00      27.58       1.00       1.1830  1.1606     128.420  127.057      772.30  790.65      1.4090  1.3105     0.9380  0.9393     0.8870  0.8366     0.012900  0.012861
    17     100.00      11.86       1.00       1.1520  1.1320     138.740  136.072      781.70  800.66      1.7390  1.4467     0.9630  0.9555     1.0470  1.0220     0.012400  0.012091
    18     100.00       0.00       0.00       1.0710  1.0221     157.590  159.367      802.30  827.94      2.0560  1.9697     1.0000  0.9844     1.7690  2.1111     0.009500  0.009698
    19      15.60       0.00       0.00       1.0000  0.9798         NaN  159.367      858.60  863.68         NaN  3.3862        NaN  0.9981        NaN  1.0280          NaN  0.015095
END
set xlabel "Pressure (barg)"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_014_LV_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_014_MR_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Density (kg/m3)"
set output "Figures/Expt_014_LDEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_014_LVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_014_GZ_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_014_GSG_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_014_GVIS_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Lab2 CCE of Surface Sample"
show title

$Expt << END
#           Pres          Rel Vol         Density (g/cm3)
#  Stg     (psig)      Expt    Calc        Expt     Calc
#------   --------   ----------------   ------------------
     1     3650.0     1.0000  1.0000     0.69540  0.69842
     2     3700.0     0.9992  0.9991     0.69600  0.69902
     3     3800.0     0.9978  0.9975     0.69700  0.70021
     4     3900.0     0.9963  0.9958     0.69800  0.70137
     5     4000.0     0.9949  0.9942     0.69900  0.70251
     6     4100.0     0.9935  0.9926     0.70000  0.70363
     7     4200.0     0.9922  0.9910     0.70090  0.70473
     8     4300.0     0.9909  0.9895     0.70190  0.70581
     9     4500.0     0.9883  0.9866     0.70370  0.70792
    10     5000.0     0.9823  0.9797     0.70800  0.71291
    11     5500.0     0.9768  0.9734     0.71200  0.71752
    12     6000.0     0.9717  0.9676     0.71570  0.72180
    13     6500.0     0.9671  0.9623     0.71910  0.72579
END
set xlabel "Pressure (psig)"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_016_DEN_vs_PRES_1.pdf"
plot [*<0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"

set title "CCE of Lab3_MDT1_Oil"
show title

$Expt << END
#           Pres          Rel Vol          Liq Sat (%)       Liq Den (g/cm3)
#  Stg      (bar)      Expt    Calc       Expt    Calc        Expt     Calc
#------   --------   ----------------   ----------------   ------------------
     1     981.73     0.9130  0.9036     100.00  100.00     0.76800  0.76063
     2     930.09     0.9160  0.9069     100.00  100.00     0.76600  0.75785
     3     861.28     0.9210  0.9117     100.00  100.00     0.76100  0.75385
     4     758.96     0.9300  0.9198     100.00  100.00     0.75400  0.74724
     5     647.82     0.9410  0.9301     100.00  100.00     0.74500  0.73894
     6     585.70     0.9480  0.9368     100.00  100.00     0.74000  0.73366
     7     516.41     0.9560  0.9452     100.00  100.00     0.73400  0.72711
     8     481.11     0.9600  0.9500     100.00  100.00     0.73000  0.72345
     9     445.60     0.9650  0.9552     100.00  100.00     0.72700  0.71953
    10     411.13     0.9700  0.9606     100.00  100.00     0.72300  0.71546
    11     372.66     0.9750  0.9673     100.00  100.00     0.71900  0.71055
    12     354.11     0.9790  0.9707     100.00  100.00     0.71600  0.70804
    13     310.54     0.9850  0.9794     100.00  100.00     0.71100  0.70171
    14     275.92     0.9920  0.9872     100.00  100.00     0.70700  0.69618
    15     242.90     0.9990  0.9955     100.00  100.00     0.70200  0.69042
    16     230.63     1.0000  1.0000     100.00   99.67     0.70100  0.68896
    17     227.66     1.0030  1.0038      99.94   98.90         NaN  0.69028
    18     206.77     1.0300  1.0348      95.27   93.39         NaN  0.69954
    19     190.29     1.0580  1.0662      91.25   88.81         NaN  0.70687
    20     155.13     1.1460  1.1643      81.88   77.98         NaN  0.72276
    21     120.45     1.3050  1.3362      69.78   65.25         NaN  0.73900
    22      54.33     2.3520  2.4410      36.41   32.81         NaN  0.77372
END
set xlabel "Pressure (bar)"
set ylabel "Relative Volume"
set output "Figures/Expt_018_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_018_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_018_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"

set title "DLE of Lab3_MDT1_Oil"
show title

$Expt << END
#           Temp        Pres                   Tot Vol 2 (m3)        Removed (sm3)        Liq Den (g/cm3)      Liq Vis (cp)        Gas Den (g/cm3)      Gas Sp Gravity      Gas Z-Factor
#  Stg       (C)       (bar)       Stg Wgt      Expt    Calc        Expt      Calc         Expt     Calc       Expt    Calc        Expt      Calc        Expt    Calc       Expt    Calc
#------   --------   ---------   ----------   ----------------   --------------------   ------------------   ----------------   --------------------   ----------------   ----------------
     1     102.00     354.110       1.00          NaN  1.4259          NaN    0.0000         NaN  0.70804     0.5870  0.5714          NaN  0.295826        NaN  0.9016        NaN  1.0022
     2     102.00     330.940       1.00          NaN  1.4326          NaN    0.0000         NaN  0.70476     0.5740  0.5478          NaN  0.273779        NaN  0.8675        NaN  0.9737
     3     102.00     303.360       1.00          NaN  1.4411          NaN    0.0000         NaN  0.70060     0.5570  0.5196          NaN  0.248598        NaN  0.8338        NaN  0.9448
     4     102.00     275.850       1.00          NaN  1.4503          NaN    0.0000         NaN  0.69617     0.5420  0.4915          NaN  0.224206        NaN  0.8060        NaN  0.9209
     5     102.00     248.280       1.00          NaN  1.4603          NaN    0.0000         NaN  0.69140     0.5270  0.4633          NaN  0.200205        NaN  0.7829        NaN  0.9016
     6     102.00     234.420       1.00          NaN  1.4657          NaN    0.0000         NaN  0.68886     0.5190  0.4491          NaN  0.188254        NaN  0.7730        NaN  0.8938
     7     102.00     230.630       1.00       1.4690  1.4641       0.0000    0.9578         NaN  0.68896     0.5170  0.4490          NaN  0.184997        NaN  0.7704        NaN  0.8918
     8     102.00     175.810       1.00       1.4130  1.3668      35.1000   38.1276         NaN  0.71338     0.7370  0.5687     0.137300  0.138380     0.7340  0.7416     0.8730  0.8749
     9     102.00     113.760       1.00       1.3180  1.2700      70.8000   74.6189         NaN  0.74209     0.8840  0.7567     0.084900  0.087482     0.7120  0.7305     0.8860  0.8821
    10     102.00      44.820       1.00       1.2140  1.1676     107.9000  111.3463         NaN  0.77698     1.2500  1.0736     0.034400  0.035259     0.7670  0.7837     0.9280  0.9251
    11     102.00      13.790       1.00       1.1610  1.1122     124.5000  129.0270         NaN  0.79632     1.5150  1.2981     0.012600  0.013343     0.9410  0.9965     0.9600  0.9564
    12     102.00       3.030       0.25       1.1160  1.0636     138.3000  141.0145         NaN  0.81047     1.7510  1.5003     0.004300  0.004668     1.5060  1.6140     0.9760  0.9729
    13     102.00       1.010       0.00       1.0760  1.0256     146.0000  148.5662         NaN  0.81963     2.0380  1.6619     0.002000  0.002221     2.0930  2.3241     0.9840  0.9814
    14      15.00       1.010       0.00       1.0000  0.9797          NaN  148.5662     0.86900  0.85799        NaN  2.9480          NaN  0.001310        NaN  1.0715        NaN  0.9983
END
set xlabel "Pressure (bar)"
set ylabel "Volume, After Removal (m3)"
set output "Figures/Expt_019_V2_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_019_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_019_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_019_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_019_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:15 with points title "Expt", $Expt using 3:16 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_019_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"

set title "Swelling of Lab3_Surface_Oil with 23% C2+ Gas"
show title

$Expt << END
#                                        Sat Pres (psia)      Liq Vol Frac       Density (g/cm3)         Rel Vol             C30+ K-Value
#  Stg      Rel Moles Inj      Feed       Expt    Calc        Expt    Calc        Expt     Calc       Expt    Calc         Expt        Calc
#------   ----------------   -------   ------------------   ----------------   ------------------   ----------------   ------------------------
     1         0.0000          NaN        3720.   3670.      1.0000  1.0000     0.69900  0.68705     1.0000  1.0009            NaN  1.1329e-04
     2         0.2500          F20        4500.   4550.      1.0000  1.0000     0.67700  0.65513     1.1100  1.1108            NaN  1.5851e-03
     3         0.6667          F40        5800.   5723.      1.0000  1.0000     0.62100  0.61587     1.3000  1.2900            NaN  2.7626e-02
     4         1.0000          F50        6710.   6533.      1.0000  1.0000     0.58300  0.59339     1.4800  1.4290            NaN  1.5561e-01
     5         1.0500          NaN          NaN   6653.         NaN  1.0000         NaN  0.59058        NaN  1.4493            NaN  2.0235e-01
     6         1.1000          NaN          NaN   6774.         NaN  1.0000         NaN  0.58793        NaN  1.4695            NaN  2.6648e-01
     7         1.1500          NaN          NaN   6897.         NaN  1.0000         NaN  0.58543        NaN  1.4894            NaN  3.5835e-01
     8         1.2000          NaN          NaN   7025.         NaN  1.0000         NaN  0.58310        NaN  1.5091            NaN  4.9715e-01
     9         1.2500          NaN          NaN   7158.         NaN  1.0000         NaN  0.58095        NaN  1.5285            NaN  7.1209e-01
    10         1.3000          NaN          NaN   7300.         NaN  1.0000         NaN  0.57900        NaN  1.5475     1.0000e+00  1.0000e+00
    11         1.3500          NaN          NaN   7447.         NaN  0.0000         NaN  0.57722        NaN  1.5662            NaN  7.6023e-01
    12         1.4000          NaN          NaN   7599.         NaN  0.0000         NaN  0.57558        NaN  1.5846            NaN  6.2489e-01
    13         1.4500          NaN          NaN   7753.      0.0000  0.0000         NaN  0.57404        NaN  1.6028            NaN  5.3829e-01
    14         1.5000          F60        7750.   7907.      0.0000  0.0000     0.54800  0.57259     1.7300  1.6208            NaN  4.7757e-01
    15         2.3333          NaN          NaN  10297.      0.0000  0.0000         NaN  0.55491        NaN  1.9131            NaN  1.9817e-01
    16         4.0000          NaN          NaN  13547.      0.0000  0.0000         NaN  0.53289        NaN  2.4934            NaN  9.8388e-02
    17         5.6667          NaN          NaN  15002.      0.0000  0.0000         NaN  0.51526        NaN  3.0971            NaN  6.4604e-02
    18         7.0000          NaN          NaN  15280.      0.0000  0.0000         NaN  0.50208        NaN  3.6040            NaN  4.9971e-02
    19         9.0000          F90       15000.  14965.      0.0000  0.0000         NaN  0.48395        NaN  4.4013            NaN  3.6628e-02
END
set xlabel "Relative Moles Injected"
set ylabel "Saturation Pressure (psia)"
set output "Figures/Expt_021_SATP_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Volume Fraction"
set output "Figures/Expt_021_LVF_vs_RMI_1.pdf"
plot [0:*][0:1] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_021_DEN_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:8 with points title "Expt", $Expt using 2:9 with lines title "Calc"
set ylabel "Relative Volume"
set output "Figures/Expt_021_RV_vs_RMI_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 100% Lab3_Surface_Oil, 0% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     6000.0       1.00       0.9730  0.9674     100.00  100.00         NaN   96.74      0.71900  0.71085
     2     5500.0       1.00       0.9790  0.9734     100.00  100.00         NaN   97.34      0.71500  0.70645
     3     5000.0       1.00       0.9840  0.9800     100.00  100.00         NaN   98.00      0.71100  0.70171
     4     4750.0       1.00       0.9870  0.9835     100.00  100.00         NaN   98.35      0.70900  0.69920
     5     4500.0       1.00       0.9900  0.9872     100.00  100.00         NaN   98.72      0.70700  0.69659
     6     4250.0       1.00       0.9930  0.9911     100.00  100.00         NaN   99.11      0.70400  0.69386
     7     4000.0       1.00       0.9960  0.9952     100.00  100.00         NaN   99.52      0.70200  0.69101
     8     3720.0       1.00       1.0000  1.0000     100.00  100.00         NaN  100.00      0.69900  0.68766
     9     3400.0       1.00       1.0230  1.0222      96.10   95.59       98.29   97.71          NaN  0.67274
    10     3000.0       1.00       1.0620  1.0643      90.16   88.77       95.71   94.47          NaN  0.64610
    11     2500.0       1.00       1.1380  1.1447      81.56   79.30       92.79   90.78          NaN  0.60072
    12     2000.0       1.00       1.2670  1.2807      71.14   68.17       90.16   87.31          NaN  0.53695
    13     1500.0       1.00       1.5090  1.5335      58.01   54.72       87.56   83.91          NaN  0.44843
    14     1000.0       1.00       2.0450  2.0914      41.63   38.44       85.12   80.38          NaN  0.32881
    15      450.0       1.00       4.4700  4.3562      18.17   17.35       81.21   75.57          NaN  0.15786
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_022_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_022_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_022_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 80% Lab3_Surface_Oil, 20% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     6000.0       1.00       0.9790  0.9729     100.00  100.00         NaN  97.292      0.68100  0.67160
     2     5500.0       1.00       0.9860  0.9806     100.00  100.00         NaN  98.058      0.67700  0.66636
     3     5250.0       1.00       0.9890  0.9847     100.00  100.00         NaN  98.469      0.67500  0.66358
     4     5000.0       1.00       0.9930  0.9890     100.00  100.00         NaN  98.901      0.67200  0.66068
     5     4750.0       1.00       0.9960  0.9936     100.00  100.00         NaN  99.356      0.67000  0.65765
     6     4500.0       1.00       1.0000  1.0000     100.00   99.17         NaN  99.170      0.66700  0.65342
     7     4250.0       1.00       1.0130  1.0145      95.80   95.14      97.000  96.518          NaN  0.64408
     8     3750.0       1.00       1.0460  1.0525      88.41   87.37      92.520  91.952          NaN  0.62084
     9     3250.0       1.00       1.0970  1.1081      81.59   79.45      89.510  88.038          NaN  0.58968
    10     2750.0       1.00       1.1760  1.1929      73.83   70.85      86.790  84.524          NaN  0.54773
    11     2250.0       1.00       1.3050  1.3297      64.65   61.09      84.340  81.230          NaN  0.49141
    12     1750.0       1.00       1.5300  1.5678      53.48   49.76      81.820  78.008          NaN  0.41677
    13     1250.0       1.00       1.9740  2.0384      40.13   36.64      79.220  74.676          NaN  0.32056
    14      600.0       1.00       3.9240  4.0152      19.11   17.32      75.000  69.526          NaN  0.16273
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_023_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_023_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_023_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 60% Lab3_Surface_Oil, 40% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     8000.0       1.00       0.9650  0.9629     100.00  100.00         NaN   96.29      0.64300  0.64066
     2     7500.0       1.00       0.9710  0.9701     100.00  100.00         NaN   97.01      0.63900  0.63590
     3     7000.0       1.00       0.9790  0.9779     100.00  100.00         NaN   97.79      0.63400  0.63080
     4     6500.0       1.00       0.9870  0.9865     100.00  100.00         NaN   98.65      0.62900  0.62531
     5     6250.0       1.00       0.9910  0.9911     100.00  100.00         NaN   99.11      0.62600  0.62240
     6     6000.0       1.00       0.9960  0.9959     100.00  100.00         NaN   99.59      0.62300  0.61937
     7     5800.0       0.50       1.0000  1.0000     100.00  100.00         NaN  100.00      0.62100  0.61686
     8     5500.0       0.50       1.0100  1.0103      91.77   95.35       92.67   96.34          NaN  0.61054
     9     5000.0       1.00       1.0310  1.0343      84.01   87.10       86.59   90.09          NaN  0.59638
    10     4000.0       1.00       1.1000  1.1107      73.29   73.66       80.65   81.81          NaN  0.55540
    11     3000.0       1.00       1.2460  1.2654      61.24   59.79       76.29   75.66          NaN  0.48747
    12     2000.0       1.00       1.6120  1.6443      44.78   42.58       72.17   70.02          NaN  0.37516
    13     1500.0       1.00       2.0200  2.0748      34.60   32.31       69.89   67.04          NaN  0.29732
    14      965.0       1.00       3.0260  3.1128      20.60   20.38       62.32   63.43          NaN  0.19817
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_024_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_024_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_024_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 50% Lab3_Surface_Oil, 50% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------
     1     9990.0       1.00       0.9440  0.9486     100.00  100.00         NaN   94.86      0.61800  0.62791
     2     9490.0       1.00       0.9500  0.9548     100.00  100.00         NaN   95.48      0.61400  0.62382
     3     9000.0       1.00       0.9560  0.9613     100.00  100.00         NaN   96.13      0.61000  0.61956
     4     8500.0       1.00       0.9640  0.9685     100.00  100.00         NaN   96.85      0.60500  0.61495
     5     8000.0       1.00       0.9720  0.9763     100.00  100.00         NaN   97.63      0.60000  0.61003
     6     7500.0       1.00       0.9820  0.9849     100.00  100.00         NaN   98.49      0.59400  0.60476
     7     7004.0       1.00       0.9930  0.9941     100.00  100.00         NaN   99.41      0.58800  0.59914
     8     6800.0       1.00       0.9980  0.9982     100.00  100.00         NaN   99.82      0.58500  0.59670
     9     6710.0       0.50       1.0000  1.0000     100.00  100.00         NaN  100.00      0.58300  0.59560
    10     6500.0       0.50       1.0050  1.0047      91.90   98.62       92.38   99.09          NaN  0.59280
    11     6000.0       0.50       1.0200  1.0220      78.34   86.41       79.94   88.31          NaN  0.58279
    12     5000.0       1.00       1.0680  1.0729      69.49   73.84       74.25   79.23          NaN  0.55511
    13     4000.0       1.00       1.1550  1.1631      61.75   63.22       71.31   73.54          NaN  0.51206
    14     2000.0       1.00       1.7700  1.7828      37.51   35.83       66.38   63.88          NaN  0.33408
    15     1300.0       1.00       2.6150  2.6010      24.18   23.04       63.23   59.94          NaN  0.22899
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_025_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_025_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_025_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 40% Lab3_Surface_Oil, 60% Injectant"
show title

$Expt << END
#           Pres                       Rel Vol          Liq Sat (%)       Liq Rel Vol (%)      Density (g/cm3)      Gas Z-Factor
#  Stg     (psia)      Stg Wgt      Expt    Calc       Expt    Calc        Expt    Calc         Expt     Calc       Expt    Calc
#------   --------   ----------   ----------------   ----------------   ------------------   ------------------   ----------------
     1     9900.0       1.00       0.9630  0.9627      0.000   0.000       0.000   0.000      0.56900  0.59267     2.0650  1.9992
     2     9500.0       1.00       0.9680  0.9687      0.000   0.000       0.000   0.000      0.56600  0.58904     1.9920  1.9302
     3     9000.0       1.00       0.9760  0.9766      0.000   0.000       0.000   0.000      0.56100  0.58424     1.9030  1.8437
     4     8750.0       1.00       0.9810  0.9809      0.000   0.000       0.000   0.000      0.55900  0.58172     1.8590  1.8002
     5     8500.0       1.00       0.9850  0.9853      0.000   0.000       0.000   0.000      0.55600  0.57912     1.8140  1.7566
     6     8250.0       1.00       0.9890  0.9899      0.000   0.000       0.000   0.000      0.55400  0.57643     1.7680  1.7129
     7     8000.0       0.50       0.9940  0.9947      0.000   0.000       0.000   0.000      0.55100  0.57365     1.7240  1.6691
     8     7750.0       0.25       1.0000  1.0000      0.000  10.497       0.000  10.497      0.54800  0.57059     1.6790  1.6007
     9     7500.0       0.25       1.0060  1.0059     19.710  26.106      19.830  26.260      0.54500  0.56723        NaN  1.5159
    10     7000.0       0.50       1.0190  1.0197     44.130  54.127      44.970  55.193      0.53800  0.55957        NaN  1.3359
    11     6000.0       1.00       1.0570  1.0582     52.790  62.907      55.810  66.567      0.51800  0.53922        NaN  1.1072
    12     5010.0       1.00       1.1180  1.1188     51.570  58.642      57.660  65.608      0.49000  0.51000        NaN  0.9781
    13     4000.0       1.00       1.2210  1.2263     47.750  51.491      58.280  63.141      0.44900  0.46531        NaN  0.8913
    14     3000.0       1.00       1.4310  1.4378     40.820  41.821      58.430  60.129      0.38300  0.39686        NaN  0.8439
    15     1750.0       1.00       2.2000  2.1899     25.310  25.207      55.690  55.202      0.24900  0.26055        NaN  0.8482
    16      950.0       1.00       4.0050  3.9656     13.360  12.769      53.510  50.637      0.13700  0.14388        NaN  0.8930
END
set xlabel "Pressure (psia)"
set ylabel "Relative Volume"
set output "Figures/Expt_026_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:4 with points title "Expt", $Expt using 2:5 with lines title "Calc"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_026_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:6 with points title "Expt", $Expt using 2:7 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_026_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:10 with points title "Expt", $Expt using 2:11 with lines title "Calc"

set title "CCE of 10% Lab3_Surface_Oil, 90% Injectant"
show title

$Expt << END
#           Pres          Liq Sat (%)         Density (g/cm3)
#  Stg     (psia)       Expt      Calc         Expt     Calc
#------   --------   --------------------   ------------------
     1     14900.      0.86000   0.03549     0.45500  0.48349
     2     14000.      1.09000   0.54681     0.44500  0.47684
     3     13000.      1.22000   1.15874     0.44200  0.46873
     4     12000.      1.41000   1.81035     0.43400  0.45973
     5     11000.      1.76000   2.49328     0.42600  0.44964
     6     10000.      2.44000   3.19888     0.41600  0.43821
     7      9000.      3.23000   3.92273     0.40200  0.42508
     8      8000.      4.59000   4.67838     0.38800  0.40974
     9      7000.      7.15000   5.54281     0.37100  0.39139
    10      6000.      9.21000   6.78318     0.35000  0.36865
    11      5000.     10.33000   8.60270     0.32600  0.33900
    12      4000.     11.22000   9.84837     0.28900  0.29885
    13      3500.     11.24000   9.86839     0.26500  0.27333
    14      3000.     10.81000   9.39788     0.23600  0.24322
    15      1685.      7.27000   5.78257     0.13400  0.14097
END
set xlabel "Pressure (psia)"
set ylabel "Liquid Saturation (%)"
set output "Figures/Expt_027_LS_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Overall Density (g/cm3)"
set output "Figures/Expt_027_DEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"

set title "CCE of Lab3_MDT2_Oil"
show title

$Expt << END
#           Pres      Liq Vol Frac (%)         Rel Vol         Liq Den (g/cm3)
#  Stg      (kPa)       Expt    Calc        Expt    Calc        Expt     Calc
#------   --------   ------------------   ----------------   ------------------
     1     55158.      100.00  100.00      0.9530  0.9450     0.72500  0.72881
     2     48264.      100.00  100.00      0.9610  0.9538     0.71900  0.72211
     3     41383.      100.00  100.00      0.9700  0.9639     0.71300  0.71452
     4     34853.      100.00  100.00      0.9800  0.9752     0.70500  0.70629
     5     31027.      100.00  100.00      0.9860  0.9827     0.70100  0.70088
     6     27579.      100.00  100.00      0.9920  0.9902     0.69600  0.69558
     7     24146.      100.00  100.00      0.9990  0.9985     0.69200  0.68981
     8     23546.      100.00  100.00      1.0000  1.0000     0.69100  0.68874
     9     22422.       97.80   98.26      1.0130  1.0097         NaN  0.69095
    10     20684.       93.50   93.68      1.0370  1.0353         NaN  0.69869
    11     18961.       89.20   88.91      1.0680  1.0676         NaN  0.70641
    12     17237.       84.60   83.81      1.1070  1.1090         NaN  0.71421
    13     13686.       73.30   71.86      1.2370  1.2397         NaN  0.73069
    14     10370.       60.30   58.33      1.4620  1.4677         NaN  0.74685
    15      6909.       43.10   41.14      1.9770  1.9907         NaN  0.76518
END
set xlabel "Pressure (kPa)"
set ylabel "Liquid Volume Fraction (%)"
set output "Figures/Expt_030_LVF_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 2:3 with points title "Expt", $Expt using 2:4 with lines title "Calc"
set ylabel "Relative Volume"
set output "Figures/Expt_030_RV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:5 with points title "Expt", $Expt using 2:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_030_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 2:7 with points title "Expt", $Expt using 2:8 with lines title "Calc"

set title "DLE of Lab3_MDT2_Oil at 92.2 C"
show title

$Expt << END
#           Temp        Pres                    Removed (sm3)      Liq Den (g/cm3)      Liq Vol (m3)       Liq Vis (cp)        Gas Den (g/cm3)          Gas MW         Gas Sp Gravity       Gas Z-Factor          Gas Vis (cp)             N2 y (%)             CO2 y (%)          C1 y (%)           C2 y (%)           C3 y (%)           C4+ y (%)           C6+ y (%)
#  Stg       (C)       (kPa)       Stg Wgt      Expt    Calc        Expt     Calc       Expt    Calc       Expt    Calc        Expt      Calc        Expt    Calc       Expt    Calc        Expt     Calc        Expt      Calc         Expt      Calc        Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc
#------   --------   ---------   ----------   ----------------   ------------------   ----------------   ----------------   --------------------   ----------------   ----------------   ------------------   --------------------   --------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------
     1     92.200     34853.0       1.00         0.00    0.00     0.70500  0.70629     1.4870  1.4793     0.7840  0.5630          NaN  0.298517        NaN  25.722        NaN  0.8881         NaN  0.98864          NaN  0.036446          NaN   0.58954        NaN  1.2570        NaN  80.312        NaN   5.506        NaN   4.041        NaN   8.294         NaN   4.9291
     2     92.200     32406.0       1.00         0.00    0.00         NaN  0.70289        NaN  1.4865     0.7510  0.5390          NaN  0.274884        NaN  24.687        NaN  0.8523         NaN  0.95807          NaN  0.033202          NaN   0.59417        NaN  1.2732        NaN  81.166        NaN   5.510        NaN   3.971        NaN   7.486         NaN   4.2623
     3     92.200     29648.0       1.00         0.00    0.00         NaN  0.69882        NaN  1.4951     0.7220  0.5118          NaN  0.249246        NaN  23.721        NaN  0.8190         NaN  0.92887          NaN  0.029970          NaN   0.59406        NaN  1.2940        NaN  81.998        NaN   5.527        NaN   3.903        NaN   6.685         NaN   3.6119
     4     92.200     27234.0       1.00         0.00    0.00         NaN  0.69502        NaN  1.5033     0.7000  0.4879          NaN  0.227329        NaN  23.012        NaN  0.7945         NaN  0.90756          NaN  0.027407          NaN   0.58965        NaN  1.3151        NaN  82.626        NaN   5.554        NaN   3.852        NaN   6.063         NaN   3.1145
     5     92.200     24821.0       1.00         0.00    0.00         NaN  0.69098        NaN  1.5121     0.6770  0.4640          NaN  0.205712        NaN  22.411        NaN  0.7738         NaN  0.89018          NaN  0.025043          NaN   0.58150        NaN  1.3394        NaN  83.165        NaN   5.597        NaN   3.811        NaN   5.506         NaN   2.6754
     6     92.200     23546.0       1.00         0.00    0.00     0.69100  0.68874     1.5170  1.5170     0.6670  0.4514          NaN  0.194367        NaN  22.132        NaN  0.7641         NaN  0.88261          NaN  0.023868          NaN   0.57580        NaN  1.3536        NaN  83.413        NaN   5.627        NaN   3.795        NaN   5.236         NaN   2.4649
     7     92.200     17926.0       1.00        39.00   37.73     0.71600  0.71108     1.4170  1.4218     0.7430  0.5583     0.146000  0.144862     20.900  21.194     0.7220  0.7317     0.84600  0.86339     0.019700  0.019328      0.50000   0.54044     1.4430  1.4316     84.108  84.150      5.895   5.844      3.836   3.783      4.215   4.250      1.5560   1.7027
     8     92.200     12411.0       1.00        73.00   73.08     0.73800  0.73677     1.3340  1.3301     0.9290  0.7194     0.097000  0.097711     20.400  20.776     0.7040  0.7173     0.85800  0.86872     0.016700  0.016031      0.39000   0.46622     1.5550  1.5688     84.360  83.940      6.334   6.376      3.941   3.988      3.419   3.660      0.9830   1.2072
     9     92.200      6895.0       1.00       103.00  104.98     0.76000  0.76404     1.2610  1.2451     1.1440  0.9451     0.053000  0.053600     20.900  21.234     0.7220  0.7331     0.89000  0.89920     0.014500  0.013895      0.32000   0.33766     1.7960  1.8496     81.772  81.236      7.732   7.855      4.822   4.932      3.554   3.789      0.8290   1.0018
    10     92.200      2758.0       1.00       126.00  128.40     0.78200  0.78691     1.1970  1.1787     1.4430  1.1854     0.022000  0.023208     23.200  23.985     0.8010  0.8281     0.93800  0.93831     0.013000  0.012705      0.37000   0.18360     2.0880  2.3322     73.077  71.461     11.163  11.657      7.903   8.314      5.399   6.053      1.0170   1.3721
    11     92.200       101.3       0.00       161.00  164.59     0.81200  0.82635     1.0610  1.0244     2.6010  1.8081     0.002000  0.001788     50.800  52.939     1.7530  1.8278     0.99600  0.98766     0.009300  0.009958      0.48400   0.02638     1.3280  1.4103     21.877  21.535     12.236  12.093     18.925  19.115     45.150  45.821     19.2640  20.0249
    12     15.000       101.3       0.00       161.00  164.59     0.86100  0.85941     1.0000  0.9850        NaN  2.9680          NaN  0.001197        NaN  28.253        NaN  0.9755         NaN  0.99784          NaN  0.014411          NaN  62.13350        NaN  0.6904        NaN  22.955        NaN   4.718        NaN   4.707        NaN   4.796         NaN   1.1189
END
set xlabel "Pressure (kPa)"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_031_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_031_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_031_LV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_031_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_031_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_031_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_031_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:19 with points title "Expt", $Expt using 3:20 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_031_GVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:21 with points title "Expt", $Expt using 3:22 with lines title "Calc"
set ylabel "Gas C1 Mole Fraction (%)"
set output "Figures/Expt_031_Y-C1_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:27 with points title "Expt", $Expt using 3:28 with lines title "Calc"
set ylabel "Gas C2 Mole Fraction (%)"
set output "Figures/Expt_031_Y-C2_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:29 with points title "Expt", $Expt using 3:30 with lines title "Calc"
set ylabel "Gas C3 Mole Fraction (%)"
set output "Figures/Expt_031_Y-C3_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:31 with points title "Expt", $Expt using 3:32 with lines title "Calc"
set ylabel "Gas C4+ Mole Fraction (%)"
set output "Figures/Expt_031_Y-C4+_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:33 with points title "Expt", $Expt using 3:34 with lines title "Calc"

set title "DLE of Lab3_MDT2_Oil at 70 C"
show title

$Expt << END
#          Temp        Pres                    Removed (sm3)      Liq Den (g/cm3)      Liq Vol (m3)       Liq Vis (cp)        Gas Den (g/cm3)          Gas MW         Gas Sp Gravity       Gas Z-Factor          Gas Vis (cp)             N2 y (%)             CO2 y (%)          C1 y (%)           C2 y (%)           C3 y (%)           C4+ y (%)           C6+ y (%)
# Stg       (C)       (kPa)       Stg Wgt      Expt    Calc        Expt     Calc       Expt    Calc       Expt    Calc        Expt      Calc        Expt    Calc       Expt    Calc        Expt     Calc        Expt      Calc         Expt      Calc        Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc       Expt    Calc        Expt     Calc
#-----   --------   ---------   ----------   ----------------   ------------------   ----------------   ----------------   --------------------   ----------------   ----------------   ------------------   --------------------   --------------------   ----------------   ----------------   ----------------   ----------------   ----------------   ------------------
    1     70.000     22408.0       1.00         0.00    0.00     0.70700  0.70371     1.4510  1.4510        NaN  0.5443          NaN  0.195500        NaN  21.154        NaN  0.7304         NaN  0.84984          NaN  0.023611          NaN   0.61372        NaN  1.2902        NaN  85.071        NaN   5.309        NaN   3.441        NaN   4.275         NaN   1.8775
    2     70.000     17926.0       1.00        29.00   27.25     0.72500  0.71921     1.3820  1.3871     1.2600  0.6310     0.146000  0.153440     19.200  20.402     0.6620  0.7044     0.82300  0.83541     0.019400  0.019620      0.46000   0.58255     1.0550  1.3494     88.686  85.850      4.490   5.422      2.779   3.351      2.527   3.446      0.7260   1.2956
    3     70.000     12411.0       1.00        65.00   63.14     0.74900  0.74448     1.2990  1.2994     1.3670  0.8118     0.098000  0.102499     18.900  19.903     0.6540  0.6872     0.83800  0.84467     0.016300  0.015847      0.25000   0.50489     1.1230  1.4799     89.378  86.041      4.502   5.826      2.616   3.397      2.132   2.751      0.6110   0.8159
    4     70.000      6895.0       1.00        94.00   96.18     0.77500  0.77187     1.2260  1.2168     1.5580  1.0704     0.052000  0.055044     19.100  20.159     0.6590  0.6960     0.88000  0.88508     0.014000  0.013472      0.16000   0.36265     1.3210  1.7745     87.938  84.024      5.528   7.149      3.108   4.055      1.948   2.635      0.3880   0.5920
    5     70.000      2758.0       1.00       116.00  120.45     0.79700  0.79479     1.1660  1.1529     1.8480  1.3453     0.022000  0.023068     21.300  22.296     0.7340  0.7698     0.93000  0.93432     0.012600  0.012292      0.10000   0.19373     1.9570  2.3592     79.085  75.584      9.551  10.981      5.975   6.848      3.335   4.034      0.4900   0.7376
    6     70.000       103.0       0.00       152.00  154.96     0.82300  0.83093     1.0410  1.0224     3.1250  1.9561     0.002000  0.001670     48.900  45.739     1.6890  1.5792     0.99100  0.98866     0.008800  0.009839      2.03000   0.02947     1.8090  1.7840     14.932  25.846     15.914  14.683     23.980  21.607     41.335  36.051     12.0260  11.5539
    7     15.000       101.3       0.00       152.00  154.96     0.85700  0.85438     1.0000  0.9944        NaN  2.7810          NaN  0.001220        NaN  28.756        NaN  0.9928         NaN  0.99673          NaN  0.013230          NaN  47.40328        NaN  1.0608        NaN  29.897        NaN   7.257        NaN   7.451        NaN   6.931         NaN   1.3311
END
set xlabel "Pressure (kPa)"
set ylabel "Cumulative Removal (sm3)"
set output "Figures/Expt_032_MR_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:5 with points title "Expt", $Expt using 3:6 with lines title "Calc"
set ylabel "Liquid Phase Density (g/cm3)"
set output "Figures/Expt_032_LDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:7 with points title "Expt", $Expt using 3:8 with lines title "Calc"
set ylabel "Liquid Volume (m3)"
set output "Figures/Expt_032_LV_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:9 with points title "Expt", $Expt using 3:10 with lines title "Calc"
set ylabel "Liquid Phase Viscosity (cp)"
set output "Figures/Expt_032_LVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:11 with points title "Expt", $Expt using 3:12 with lines title "Calc"
set ylabel "Gas Phase Density (g/cm3)"
set output "Figures/Expt_032_GDEN_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:13 with points title "Expt", $Expt using 3:14 with lines title "Calc"
set ylabel "Gas Specific Gravity"
set output "Figures/Expt_032_GSG_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:17 with points title "Expt", $Expt using 3:18 with lines title "Calc"
set ylabel "Gas Phase Z-Factor"
set output "Figures/Expt_032_GZ_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:19 with points title "Expt", $Expt using 3:20 with lines title "Calc"
set ylabel "Gas Phase Viscosity (cp)"
set output "Figures/Expt_032_GVIS_vs_PRES_1.pdf"
plot [0:*][0:*] $Expt using 3:21 with points title "Expt", $Expt using 3:22 with lines title "Calc"
set ylabel "Gas C1 Mole Fraction (%)"
set output "Figures/Expt_032_Y-C1_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:27 with points title "Expt", $Expt using 3:28 with lines title "Calc"
set ylabel "Gas C2 Mole Fraction (%)"
set output "Figures/Expt_032_Y-C2_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:29 with points title "Expt", $Expt using 3:30 with lines title "Calc"
set ylabel "Gas C3 Mole Fraction (%)"
set output "Figures/Expt_032_Y-C3_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:31 with points title "Expt", $Expt using 3:32 with lines title "Calc"
set ylabel "Gas C4+ Mole Fraction (%)"
set output "Figures/Expt_032_Y-C4+_vs_PRES_1.pdf"
plot [0:*][0:100] $Expt using 3:33 with points title "Expt", $Expt using 3:34 with lines title "Calc"

set output
